<?php

namespace Inside\RHLH\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Lang;

class RegistrationAccepted extends Mailable
{
    use Queueable;
    use SerializesModels;

    protected string $token;
    protected string $email;

    public function __construct(string $email, string $token)
    {
        $this->token = $token;
        $this->email = $email;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build(): self
    {
        $resetLink = sprintf('%s/password/reset?token=%s&email=%s', env('APP_URL'), $this->token, $this->email);

        return $this
            ->markdown('emails.registration_accepted')
            ->subject(Lang::get('registration.mail.accepted.subject'))
            ->with(
                [
                'content' => Lang::get('registration.mail.accepted.content'),
                'url' => $resetLink,
                'button' => Lang::get('registration.mail.accepted.button'),
            ]
            );
    }
}
