<?php

namespace Inside\RHLH\Actions;

use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Validator;
use Inside\RHLH\Models\RegistrationNumber;
use Inside\Support\Str;

class TransformCsvRowIntoRegistrationNumber
{
    /**
     * @param array<string> $row
     * @return bool
     */
    public function transform(array $row): bool
    {
        $user = collect(config('registration_number.mapping'))
            ->map(fn ($key) => $row[$key] ?: null)
            ->map(fn ($value, $key) => match (true) {
                $value === '00/00/0000' => null,
                Str::contains($key, 'date') => Carbon::createFromFormat('d/m/Y', $value),
                default => strtolower($value)
            });

        $validator = Validator::make(
            data: $user->toArray(),
            rules:config('registration_number.rules')
        );

        if ($validator->fails()) {
            Log::alert("RHLH: ({$user->implode(',')}) ne respecte pas les conditions d'imports");

            return false;
        }

        $user->put('is_manager', false);
        if (! $user->get('manager_email')) {
            $user->put('manager_email', config('registration_number.super_manager'));
            $user->put('is_manager', true);
        }

        RegistrationNumber::updateOrCreate(
            ['registration_number' => $user->get('registration_number')],
            $user->toArray()
        );

        return true;
    }
}
