<?php

namespace Inside\RHLH\Actions;

use Illuminate\Support\Facades\Mail;
use Inside\Content\Models\Contents\Users as UserContent;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;
use Inside\RHLH\Mail\PendingAccount;

class NotifyManagerToReviewUser extends BaseNotificationListener
{
    public function __invoke(UserContent $user): void
    {
        $notificationType = NotificationType::where('type', 'system')->where('action', 'rhlh_user_registered')->first();

        if (! $notificationType instanceof  NotificationType) {
            return;
        }

        $this->notify(
            $notificationType,
            $this->route,
            $user,
            ['url' => 'settings/inscriptions?user=' . $user->uuid]
        );

        Mail::to($user->hotelManager->first()->email)->send(new PendingAccount($user));
    }
}
