<?php

namespace Inside\RHLH\Actions;

use Illuminate\Support\Facades\Mail;
use Inside\RHLH\Mail\RegistrationAccepted;
use Inside\User\Models\User;

class MailAcceptedUser
{
    public function __invoke(User $user): void
    {
        $token = app('auth.password.broker')->createToken($user);

        if (! $user->email) {
            return;
        }

        Mail::to($user->email)->send(new RegistrationAccepted($user->email, $token));
    }
}
