<?php

namespace Inside\RHLH\Actions;

use Inside\Support\Str;
use Spatie\SimpleExcel\SimpleExcelReader;

class ImportNewRegistrationNumbersFromCsv
{
    /**
     * @param string $path
     * @return array<string, int>
     */
    public function register(string $path): array
    {
        $action = new TransformCsvRowIntoRegistrationNumber();

        $result = SimpleExcelReader::create($path)
            ->formatHeadersUsing(fn ($header) => Str::ascii($header))
            ->headersToSnakeCase()
            ->useDelimiter(';')
            ->getRows()
            ->map(static fn ($row) => $action->transform($row) ? 'imported' : 'rejected')
            ->toArray();

        return array_count_values($result);
    }
}
