@php
    use Illuminate\Support\Facades\App;
    $assetPath    = '/themes/custom/inside-drupal-theme/assets';
    $documentRoot = filter_input(INPUT_SERVER, 'DOCUMENT_ROOT', FILTER_SANITIZE_STRING);
    $buildTime    = file_exists($documentRoot . $assetPath) ? filemtime($documentRoot . $assetPath) ?? 0 : 0;
@endphp
    <!DOCTYPE html>
<html lang="{{ App::getLocale() }}" dir="ltr">
<head>

    @if (!empty(env('LHG_COOKIELAW_KEY', false)))
        <!-- Début de la mention OneTrust de consentement aux cookies du domaine : [keepintouch.louvrehotels.com](http://keepintouch.louvrehotels.com/) -->
        <script type="text/javascript" src=https://cdn.cookielaw.org/consent/{{ env('LHG_COOKIELAW_KEY') }}/OtAutoBlock.js ></script>
        <script src=https://cdn.cookielaw.org/scripttemplates/otSDKStub.js type="text/javascript" charset="UTF-8" data-domain-script="{{ env('LHG_COOKIELAW_KEY') }}" ></script>
        <script type="text/javascript">
            function OptanonWrapper() { }
        </script>
        <!-- Fin de la mention OneTrust de consentement aux cookies du domaine : [keepintouch.louvrehotels.com](http://keepintouch.louvrehotels.com/) -->
    @endif
    <meta charset="utf-8"/>
    <meta name="viewport" content="width=device-width,user-scalable=yes,initial-scale=1.0,maximum-scale=5.0"/>
    <meta name="HandheldFriendly" content="true"/>

    <meta name="application-name" content="{{ env('APP_NAME') }}"/>
    <meta name="mobile-web-app-capable" content="yes"/>
    <meta name="theme-color" content="{{ env('WEBAPP_COLOR', '#fbb3a7') }}"/>

    <meta name="apple-mobile-web-app-capable" content="yes"/>
    <meta name="apple-mobile-web-app-title" content="{{ env('APP_NAME') }}"/>
    <meta name="apple-mobile-web-app-status-bar-style" content="#ffffff"/>

    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="format-detection" content="telephone=no"/>

    <meta name="msapplication-config" content="{{ $assetPath }}/assets/browserconfig.xml"/>
    <meta name="msapplication-TileColor" content="{{ env('WEBAPP_COLOR', '#fbb3a7') }}"/>
    <meta name="msapplication-TileImage" content="{{ $assetPath }}/assets/img/app-logo/mstile-144x144.png"/>

    <meta name="robots" content="noindex"/>
    <meta name="description" content="{{ env('APP_NAME') }}"/>

    <title>{{ env('APP_NAME') }}</title>
    <x-logo-header :path="$assetPath" :build="$buildTime"/>
    {!! Inside::css() !!}
    {!! Inside::headerJs() !!}
</head>
<body>
<div id="app"></div>
{!! Inside::script() !!}
{!! Inside::js() !!}
</body>
</html>
