<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddManagerUuidOnRhlhUsersTable extends Migration
{
    public function up(): void
    {
        Schema::table('rhlh_users', static function (Blueprint $table) {
            $table->uuid('manager_uuid')->nullable()->after('user_uuid');
            $table->foreign('manager_uuid')->references('uuid')->on('inside_users');
        });
    }

    public function down(): void
    {
        Schema::table('rhlh_users', static function (Blueprint $table) {
            $table->dropForeign('inside_users_manager_uuid_foreign');
            $table->removeColumn('manager_uuid');
        });
    }
}
