<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Notify\Models\NotificationType;

class AddUserRegistrationFields extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $fields = [
            [
                'type'                => BridgeContentType::LIST_STRING_FIELD,
                'name'                => 'registration_status',
                'searchable'          => false,
                'translatable'        => true,
                'search_result_field' => true,
                'required'            => true,
                'weight'              => 9,
                'title'               => [
                    'fr' => 'Statut d\'inscription',
                ],
                'settings' => [
                    'allowed_values' => [
                        'pending' => [
                            'fr' => 'En attente',
                        ],
                        'accepted' => [
                            'fr' => 'Accepté',
                        ],
                        'declined' => [
                            'fr' => 'Refusé',
                        ],
                    ],
                ],
                'widget'              => [
                    'hidden' => true,
                ],
            ],
            [
                'name' => 'hotel_manager',
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => true,
                'required' => false,
                'weight' => 10,
                'title' => [
                    'fr' => 'Directeur d\'hôtel',
                ],
                'widget' => [
                    'settings' => [],
                    'weight' => 10,
                    'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => 'users',
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'is_manager',
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => true,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 11,
                'title' => [
                    'fr' => 'Est un directeur d\'hôtel',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'weight' => 11,
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'default' => false,
            ]
        ];

        foreach ($fields as $field) {
            $bridge->contentTypeCreateOrUpdateField('users', $field['name'], $field);
        }

        NotificationType::firstOrCreate(
            [
                'via'       => 'web',
                'type'      => 'system',
                'default'   => false,
                'event'     => null,
                'model'     => type_to_class('users'),
                'action'    => 'rhlh_user_registered',
                'condition' => null,
                'multiple'  => false,
                'language'  => false,
                'profile'   => false,
                'data'      => [
                    'title'       => 'notifications.rhlh.register.title',
                    'description' => 'notifications.rhlh.register.description',
                    'icon'        => 'p_and_p',
                    'text'        => 'notifications.rhlh.register.text'
                ]
            ]
        );
    }

    public function down(): void
    {
    }
}
