<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Inside\Content\Models\Contents\PAndP;

class AddRhlhUsersTable extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        if (!Schema::hasTable('rhlh_users')) {
            Schema::create('rhlh_users', function (Blueprint $table) {
                $table->string('registration_number');
                $table->string('manager_registration_number');
                $table->uuid('user_uuid')->nullable();
                $table->foreign('user_uuid')->references('uuid')->on('inside_users')->onDelete('cascade');
            });
        }
    }

    public function down(): void
    {
    }
}
