<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddRegistrationNumberFieldToUsers extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateField(
            'users',
            'registration_number',
            [
                'name' => 'registration_number',
                'type' => BridgeContentType::TEXT_FIELD,
                'editable' => false,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 10,
                'title' => [
                    'fr' => 'Matricule',
                    'en' => 'Registration number',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 1,
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ]
        );
    }
}
