import { markRaw } from 'vue'

import { IconText } from 'inside-collection/atoms'
import Microsoft from '@inside-auth/components/login/extra-component/Microsoft'

const origin = new URL(
  process.env.NODE_ENV === 'development'
    ? JSON.parse(process.env.GLOBAL).localURL
    : window.location
).origin

export default {
  'inside-auth': {
    extraComponent: {
      is: Microsoft,
      link: `${origin}/saml/login`
    }
  },
  'inside-archives': {
    isEnabled: true
  },
  'inside-edition': {
    revisionEnabled: true,
    duplicateEnabled: true
  },
  'inside-events': {
    subscriptionEnabled: true,
    showBookmarks: true,
    bookmarkEnabled: true,
    extraCategoriesFilters: ['establishments']
  },
  'inside-jobs': {
    cardOverrides: (data, methods) => {
      methods.addItemBefore('contract', {
        id: 'locations',
        tag: markRaw(IconText),
        data: { icon: 'address' },
        value: data?.locations?.title,
        hideIf: () => !data?.locations?.title
      })

      methods.addItemAfter('locations', {
        id: 'establishments',
        tag: markRaw(IconText),
        data: { icon: 'building' },
        value: data?.establishments?.title,
        hideIf: () => !data?.establishments?.title
      })
    },
    extraFields: [
      { contracts_types: ['uuid', 'title', 'color'] },
      { locations: ['uuid', 'title'] },
      { establishments: ['uuid', 'title'] }
    ],
    categoriesFields: [
      {
        locations: {
          fields: ['uuid', 'title'],
          filters: { 'status:eq': 1 }
        }
      },
      {
        establishments: {
          fields: ['uuid', 'title', 'color'],
          filters: { 'status:eq': 1 }
        }
      },
      {
        contracts_types: {
          fields: ['uuid', 'title', 'color'],
          filters: { 'status:eq': 1 }
        }
      }
    ]
  },
  'inside-layouts': {
    tabsPagesBookmarkEnabled: true,
    pagesBookmarkEnabled: true,
    gdprContent: 'popins'
  },
  'inside-maps': {
    mainContentType: 'markers'
  },
  'inside-newcomers': {
    extraFields: [
      {
        field: 'functions',
        data: data => data.functions?.title
      }
    ]
  },
  'inside-news': {
    minimalDate: true,
    bookmarkEnabled: true,
    showBookmarks: true,
    extraCategoriesFilters: ['establishments'],
    templates: {
      fullContent: {
        relatedComponent: () => import('./components/news/MinimalNews'),
        relatedFields: () => [
          'image',
          'chapo',
          {
            news_categories: {
              fields: ['uuid', 'title', 'content_type', 'color', 'slug'],
              filters: { 'status:eq': 1 }
            }
          },
          {
            establishments: {
              fields: ['uuid', 'title', 'content_type', 'color', 'slug'],
              filters: { 'status:eq': 1 }
            }
          }
        ]
      }
    },
    paragraphs: {
      fetchedContents: {
        display: () => import('./components/news/MinimalNews'),
        displayAttributes: ({ item }) => ({
          to: {
            name: 'NewsPage',
            params: { slug: item.slug[0] }
          }
        }),
        selectionConfig: {
          fields: [
            'uuid_host',
            'title',
            'chapo',
            'slug',
            'image',
            'published_at',
            'content_type',
            {
              news_categories: ['uuid', 'title']
            },
            {
              establishments: ['uuid', 'title']
            }
          ],
          filters: {
            'status:eq': 1
          },
          valueCallback: item => item.uuid_host,
          labelCallback: item => item.title
        },
        requestFields: [
          'uuid',
          'title',
          'chapo',
          'slug',
          'image',
          'published_at',
          'content_type',
          {
            news_categories: ['uuid', 'title']
          },
          {
            establishments: ['uuid', 'title']
          }
        ]
      }
    }
  },
  'inside-organizational-chart': {
    functionKey: 'functions'
  },
  'inside-users': {
    csvImport: true,
    shortcuts: {
      max: 5
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    },
    paragraphs: {
      fetchedContents: {
        display: () => import('./components/users/UserCard'),
        requestFields: [
          'uuid',
          'firstname',
          'lastname',
          'phone',
          'mobile',
          'image',
          { functions: ['title', 'uuid'] }
        ]
      }
    }
  }
}
