import { http } from '@inside-library/helpers/Http'

export const fetchSpacesPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'title',
        'banner',
        'color',
        'published_at',
        'introduction',
        'admin',
        'content_type',
        'slug',
        'display_jobs',
        'link',
        'content',
        {
          users: {
            fields: [
              'uuid',
              'firstname',
              'lastname',
              'image',
              'email',
              'phone',
              'mobile',
              { functions: ['title'] }
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          tools: {
            fields: [
              'title',
              'uuid',
              'has_section',
              'tools_link',
              'admin',
              'image',
              'icon',
              'icon_color',
              'class',
              'content_type'
            ],
            filters: {
              'status:eq': 1,
              'archived:eq': 0
            }
          }
        },
        {
          documents: {
            fields: [
              'uuid',
              'title',
              'file',
              'has_section',
              'admin',
              'content_type',
              'published_at'
            ],
            filters: {
              'status:eq': 1,
              'archived:eq': 0
            }
          }
        },
        {
          news_categories: {
            fields: [
              'uuid',
              'title',
              {
                news: {
                  fields: [
                    'uuid',
                    'title',
                    'slug',
                    'chapo',
                    'published_at',
                    'image',
                    'content_type',
                    { authors: ['uuid', 'firstname', 'lastname', 'image'] },
                    { news_categories: ['uuid', 'title', 'color'] },
                    { establishments: ['uuid', 'title'] },
                    { reactions: ['count', { users: ['uuid'] }] },
                    { comments: ['count'] }
                  ],
                  filters: {
                    reverse: true,
                    'status:eq': 1,
                    sort: 'published_at:desc',
                    'published_at:lte': 'now()',
                    'archived:eq': 0,
                    limit: 4
                  }
                }
              }
            ],
            filters: {
              'status:eq': 1,
              'published_at:lte': 'now()',
              'archived:eq': 0
            }
          }
        },
        {
          establishments: {
            fields: [
              'uuid',
              'title',
              {
                news: {
                  fields: [
                    'uuid',
                    'title',
                    'slug',
                    'chapo',
                    'published_at',
                    'image',
                    'content_type',
                    { authors: ['uuid', 'firstname', 'lastname', 'image'] },
                    { news_categories: ['uuid', 'title', 'color'] },
                    { establishments: ['uuid', 'title'] },
                    { reactions: ['count', { users: ['uuid'] }] },
                    { comments: ['count'] }
                  ],
                  filters: {
                    reverse: true,
                    'status:eq': 1,
                    sort: 'published_at:desc',
                    'published_at:lte': 'now()',
                    'archived:eq': 0,
                    limit: 4
                  }
                }
              }
            ],
            filters: {
              'status:eq': 1,
              'published_at:lte': 'now()',
              'archived:eq': 0
            }
          }
        },
        {
          pages_categories: {
            fields: ['count'],
            filters: { reverse: true, 'archived:eq': 0, 'status:eq': 1 }
          }
        }
      ],
      filters: {
        'status:eq': 1,
        'slug:eq': $route.params.slug
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchSpacesPagesPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'title',
        'admin',
        'content_type',
        'banner',
        'introduction',
        'color'
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
