export default {
  documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      'image',
      { folders: ['title', 'uuid'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'image',
      'firstname',
      'lastname',
      'email',
      'phone',
      'mobile',
      'link_teams',
      'linkedin',
      { establishments: ['title'] },
      { functions: ['title'] },
      { locations: ['title'] },
      {
        users: [
          'uuid',
          'firstname',
          'lastname',
          'image',
          'phone',
          'mobile',
          { functions: ['title'] }
        ]
      }
    ]
  },
  jobs_offers: {
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'button_link',
      'link',
      { locations: ['uuid', 'title'] },
      { establishments: ['uuid', 'title'] },
      { contracts_types: ['uuid', 'title'] }
    ]
  },
  markers: {
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'phone',
      'image',
      'address',
      'schedules',
      { establishments: ['uuid', 'title'] }
    ]
  }
}
