<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class RemoveServicesFieldAndAddesmsField extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField(
            entityType: 'node',
            type: 'markers',
            fieldName: 'services',
        );

        $bridge->contentTypeCreateOrUpdateField(
            type: 'markers',
            fieldName: 'establishments',
            options: [
                'name' => 'establishments',
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => true,
                'searchable_filter' => true,
                'required' => false,
                'weight' => 9,
                'title' => [
                    'fr' => 'ESMS',
                ],
                'description' => [],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 9,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['establishments'],
                    'cardinality' => 1,
                ],
            ]
        );
    }
}
