<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class SetJobsOffersAsSearchable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->updateContentTypeOptions('jobs_offers', [
            'searchable' => true,
        ]);

        $bridge->contentTypeCreateOrUpdateField(
            type: 'markers',
            fieldName: 'services',
            options: [
                'name' => 'services',
                'title' => [
                    'fr' => 'Services',
                ],
            ],
        );
    }
}
