<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class CreateResoContentTypes extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('contracts_types', false);
        $this->migrateContent('locations', false);
        $this->migrateContent('establishments', false);
        $this->migrateContent('jobs_offers', false);
        $this->migrateContent('services', false);
        $this->migrateContent('markers', false);
        $this->migrateContent('functions', false);
        $this->migrateContent('spaces');
        $this->migrateContent('pages_categories');
        $this->migrateContent('spaces_pages');
        $this->finishUp();

        $bridgeContentType = new BridgeContentType();
        $bridgeContentType->contentTypeDeleteField('user', 'user', 'function');
        $bridgeContentType->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'establishments',
            options: [
                'name' => 'establishments',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 1,
                'title' => [
                    'fr' => 'ESMS',
                ],
                'description' => [],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 1,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['establishments'],
                    'cardinality' => 1,
                ],
            ],
            weight: -3
        );

        $bridgeContentType->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'users',
            options: [
                'name' => 'users',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 7,
                'title' => [
                    'fr' => 'Manager',
                ],
                'widget' => [
                    'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                    'settings' => [],
                    'weight' => 7,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => 'users',
                    'cardinality' => 1,
                ],
            ]
        );

        $bridgeContentType->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'functions',
            options: [
                'name' => 'functions',
                'type' => BridgeContentType::REFERENCE_FIELD,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 10,
                'title' => [
                    'fr' => 'Fonction',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'weight' => 10,
                ],
                'settings' => [
                    'target_type' => ['functions'],
                    'cardinality' => 1,
                ],
            ]
        );

        $bridgeContentType->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'link_teams',
            options: [
                'name' => 'link_teams',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 20,
                'title' => [
                    'fr' => 'Teams',
                ],
                'widget' => [
                    'type' => BridgeContentType::INSIDE_LINK_WIDGET,
                    'settings' => [],
                    'weight' => 20,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ]
        );

        $bridgeContentType->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'mobile',
            options: [
                'name' => 'mobile',
                'type' => BridgeContentType::TEXT_FIELD,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 10,
                'title' => [
                    'fr' => 'Téléphone Pro',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'weight' => 10,
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ]
        );

        $bridgeContentType->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'phone',
            options: [
                'name' => 'phone',
                'type' => BridgeContentType::TEXT_FIELD,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 11,
                'title' => [
                    'fr' => 'Téléphone fixe',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'weight' => 11,
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
        );

        $bridgeContentType->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'locations',
            options: [
                'name' => 'locations',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => true,
                'required' => false,
                'weight' => 6,
                'title' => [
                    'fr' => 'Localisation',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 6,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['locations'],
                    'cardinality' => 1,
                ],
            ]
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
    }
}
