<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddEstablishmentsToNewsAndEvents extends Migration
{
    /**
     * @return void
     */
    public function up(): void
    {
        $types = ['news', 'events'];
        $bridgeContentType = new BridgeContentType();
        foreach ($types as $type) {
            $bridgeContentType->contentTypeCreateOrUpdateField(
                type: $type,
                fieldName: 'establishments',
                options: [
                    'name' => 'establishments',
                    'searchable' => true,
                    'translatable' => false,
                    'search_result_field' => true,
                    'searchable_filter' => true,
                    'required' => false,
                    'weight' => 10,
                    'title' => [
                        'fr' => 'ESMS',
                    ],
                    'description' => [],
                    'widget' => [
                        'type' => BridgeContentType::SELECT_WIDGET,
                        'settings' => [],
                        'weight' => 1,
                    ],
                    'type' => BridgeContentType::REFERENCE_FIELD,
                    'settings' => [
                        'target_type' => ['establishments'],
                        'cardinality' => -1,
                    ],
                    'selectable_all' => true,
                ],
                weight: 10
            );
        }

        $bridgeContentType->contentTypeDeleteField('node', 'cards_links', 'is_featured');
        $bridgeContentType->contentTypeDeleteField('node', 'jobs_offers', 'button_link');
        $bridgeContentType->contentTypeDeleteField('node', 'jobs_offers', 'link');
    }
}
