<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddColorFieldForSpaces extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'spaces',
            fieldName: 'color',
            options: [
                'name' => 'color',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'search_filter' => false,
                'required' => false,
                'weight' => 3,
                'title' => [
                    'fr' => 'Couleur',
                    'en' => 'Color',
                    'es' => 'Color',
                    'de' => 'Farbe',
                    'pt' => 'Cor',
                    'nl' => 'Kleur',
                ],
                'description' => [
                    'fr' => 'Sélectionnez la couleur du titre',
                    'en' => 'Select the title color',
                    'es' => 'Seleccione el color del título',
                    'de' => 'Wählen Sie die Titelfarbe aus',
                    'pt' => 'Selecione a cor do título',
                    'nl' => 'Selecteer de titelkleur',
                ],
                'widget' => [
                    'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                    'settings' => [],
                    'weight' => 3,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
        );
    }
}
