<?php

use Illuminate\Support\Collection;
use Inside\Host\Bridge\BridgeContent;

return [
    'postfilter' => function ($users) {
        return $users->reject(function ($user) {
            return empty($user->assignedLicenses);
        });
    },

    'sync_attributes' => [
        'firstname' => 'givenName',
        'lastname' => 'surname',
        'name' => 'mail',
        'email' => 'mail',
        'phone' => fn (mixed $user) => isset($user->businessPhones[0]) ? $user->businessPhones[0] : null,
        'mobile' => 'mobilePhone',
        'functions' => fn (mixed $user) => reference('functions')
            ->identifiedBy('code')
            ->from($user->jobTitle)
            ->first(),
        'link_teams' => fn (mixed $user) => "https://teams.microsoft.com/l/chat/0/0?users=$user->userPrincipalName",
        'establishments' => fn (mixed $user) => reference('establishments')
            ->identifiedBy('code')
            ->from($user->department)
            ->first(),
        'locations' => fn (mixed $user) => reference('locations')
            ->identifiedBy('code')
            ->from($user->officeLocation)
            ->first(),
        'users' => fn (mixed $user) => reference('users')
            ->identifiedBy('email')
            ->from($user->manager)
            ->withoutCreation()
            ->first(),
    ],
];
