<?php

namespace Inside\RESO\Providers;

use Inside\Providers\ServiceProvider as BaseServiceProvider;

/**
 * RESO Service provider.
 *
 * @category Class
 * @package  Inside\\RESO\Providers\ServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    /**
     * Boot
     */
    public function boot(): void
    {
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');
    }

    /**
     * Register
     */
    public function register(): void
    {
        $this->mergeRecursiveConfigFrom(__DIR__ . '/../../config/scheduler.php', 'scheduler');
        $this->mergeConfigTo(__DIR__ . '/../../config/statistics.php', 'statistics');
        $this->mergeConfigTo(__DIR__ . '/../../config/permission.php', 'permission');
        $this->mergeConfigTo(__DIR__.'/../../config/notify.php', 'notify');
        $this->mergeConfigTo(__DIR__.'/../../config/archive.php', 'archive');
        $this->mergeConfigTo(__DIR__.'/../../config/csv.php', 'csv');
        $this->mergeConfigTo(__DIR__.'/../../config/xlsx.php', 'xlsx');
        $this->mergeConfigTo(__DIR__ . '/../../config/azuread.php', 'azuread');

        $sid2BaseStatistics = config('sid2_base_statistics');
        $backStatistics = config('statistics');

        config(['statistics' => array_merge_recursive($backStatistics, $sid2BaseStatistics)]);
        config('statistics');
    }
}
