<?php

return [
    '_meta' => [
        'type' => 'newsletters',
        'fieldsPrefix' => ''
    ],
    'banner'       => [
        'backgroundColor' => '#ffff'
    ],
    'introduction' => [
        'introductionFieldName' => 'newsletter_introduction',
        'textColor' => '#2C3E50'
    ],
    'sections'     => [
        'news'       => [
            'sectionTitleStrKey' => 'newsletter.news_title',
            'types' => ['news'],
            'dateFormat' => '%d/%m/%Y',
            'showCategoryTitle' => true,
            'defaultCategoryColor' => '#25567D',
            'link' => [
                'sectionLinkUrl'  => 'actualites',
                'sectionTextColor' => '#25567D',
            ],
        ],
        'events'     => [
            'sectionTitleStrKey' => 'newsletter.events_title',
            'types' => ['events'],
            'sorts' => ['date:desc'],
            'dateFormat' => '%d/%m/%Y',
            'categoryFieldName' => 'events_categories',
            'defaultCategoryColor' => '#25567D',
            'link' => [
                'sectionLinkUrl'   => 'events',
                'sectionTextColor' => '#25567D',
            ],
        ],
        'documents'  => [
            'sectionTitleStrKey' => 'newsletter.documents_title',
            'types'           => ['documents'],
            'sorts' => ['created_at:desc'],
            'imageStyle' => 'medium',
            'dateFormat' => '%d/%m/%Y',
            'link'            => [
                'sectionLinkStrKey' => 'newsletter.see_all_documents',
                'sectionLinkUrl' => 'mediatheque',
                'sectionTextColor' => '#25567D'
            ],
        ],
        'new_members' => [
            'sectionTitleStrKey' => 'newsletter.new_members_title',
            'introductionLength' => 50,
            'introductionFieldName' => 'movements_description',
            'types'           => ['movements'],
            'link' => [
                'sectionLinkStrKey' => 'newsletter.see_all_new_members',
                'sectionLinkUrl'   => 'movements',
                'sectionTextColor' => '#E4492D',
            ],
        ],
    ],
    'socials'      => [
        'backgroundColor' => '#25567D',
        'links' => [
            'link' => [
                'titleStrKey' => 'Site Web',
                'url' => 'https://www.res-o.fr',
            ],
            'linkedin' => [
                'url' => 'https://www.linkedin.com/company/resilience-occitanie/?originalSubdomain=fr',
            ],
        ],
    ],
    'footer'       => [
        'backgroundColor' => '#ffffff',
        'unsubscribeTextColor' => '#818181',
        'unsubscribeTextStrKey' => 'newsletter.unsubscribe.warning'
    ],
];
