<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class MakeEstablishmentsRequired extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $models = Schema::getModelsWithField('establishments');

        $required = ['news', 'events', 'markers', 'jobs_offers'];

        collect($models)
            ->reject(fn ($model) => ! in_array($model, $required))
            ->each(
                fn ($model) => $bridge->contentTypeCreateOrUpdateField(
                    type: $model,
                    fieldName: 'establishments',
                    options: [
                        'required' => true,
                        'title' => [
                            'fr' => 'ESMS',
                        ]
                    ]
                )
            );
    }
}
