<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class RenameEsmsType extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $models = Schema::getContentTypes();

        $bridge->contentTypeUpdateOrCreate(
            type: 'establishments',
            options: [
                'title' => [
                    'fr' => 'ESMS',
                ]
            ]
        );

        if (in_array('services', $models)) {
            $bridge->contentTypeDelete(
                type: 'services',
            );
        }
    }
}
