<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddLinksForJobsOffers extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'jobs_offers',
            fieldName: 'link',
            options: [
                'name' => 'link',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'search_filter' => false,
                'required' => false,
                'weight' => 14,
                'title' => [
                    'fr' => 'Lien LinkedIn',
                ],
                'widget' => [
                    'type' => BridgeContentType::INSIDE_LINK_WIDGET,
                    'settings' => [],
                    'weight' => 0,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
        );

        $bridge->contentTypeCreateOrUpdateField(
            type: 'jobs_offers',
            fieldName: 'button_link',
            options: [
                'name' => 'button_link',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'search_filter' => false,
                'required' => false,
                'weight' => 15,
                'title' => [
                    'fr' => 'Lien bouton',
                ],
                'widget' => [
                    'type' => BridgeContentType::INSIDE_LINK_WIDGET,
                    'settings' => [],
                    'weight' => 0,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ]
        );
    }
}
