<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Facades\Schema as InsideSchema;

class MakeEstablishmentsMultiple extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $models = InsideSchema::getModelsWithField('establishments');

        foreach ($models as $model) {
            if ($model === 'users') {
                $bridge->contentTypeDeleteField('user', 'user', 'establishments');
            } else {
                $bridge->contentTypeDeleteField('node', $model, 'establishments');
            }
        }

        collect($models)->each(function ($model) use ($bridge) {
            $bridge->contentTypeCreateOrUpdateField(
                type: $model,
                fieldName: 'establishments',
                options: [
                    'name' => 'establishments',
                    'searchable' => false,
                    'translatable' => false,
                    'search_result_field' => false,
                    'searchable_filter' => false,
                    'required' => false,
                    'weight' => 10,
                    'title' => [
                        'fr' => 'ESMS',
                    ],
                    'description' => [],
                    'widget' => [
                        'type' => BridgeContentType::SELECT_WIDGET,
                        'settings' => [],
                        'weight' => 1,
                    ],
                    'type' => BridgeContentType::REFERENCE_FIELD,
                    'settings' => [
                        'target_type' => ['establishments'],
                        'cardinality' => -1,
                    ],
                    'selectable_all' => true,
                ]
            );
        });
    }
}
