<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class EditFields extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'news',
            fieldName: 'establishments',
            options: [
                'required' => true,
                'title' => [
                    'fr' => 'ESMS',
                ],
            ]
        );

        $bridge->contentTypeCreateOrUpdateField(
            type: 'events',
            fieldName: 'establishments',
            options: [
                'required' => true,
                'title' => [
                    'fr' => 'ESMS',
                ],
            ]
        );

        $bridge->contentTypeCreateOrUpdateField(
            type: 'markers',
            fieldName: 'establishments',
            options: [
                'required' => true,
                'title' => [
                    'fr' => 'ESMS',
                ],
            ]
        );

        $bridge->contentTypeCreateOrUpdateField(
            type: 'jobs_offers',
            fieldName: 'establishments',
            options: [
                'required' => true,
                'title' => [
                    'fr' => 'ESMS',
                ],
            ]
        );

        $bridge->contentTypeUpdateOrCreate(
            type: 'establishments',
            options: [
                'permissible' => true,
                'categorizable' => true,
            ],
        );

        $bridge->contentTypeUpdateOrCreate(
            type: 'tools',
            options: [
                'permissible' => true,
                'categorizable' => true,
            ],
        );
    }
}
