<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class EditSpacesFields extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'spaces',
            fieldName: 'content',
            options: [
                'name' => 'content',
                'searchable' => true,
                'translatable' => true,
                'search_result_field' => false,
                'search_filter' => false,
                'required' => false,
                'weight' => 2,
                'title' => [
                    'fr' => 'Contenu',
                    'en' => 'Content',
                    'es' => 'Contenido',
                    'de' => 'Inhalt',
                    'pt' => 'Conteúdo',
                    'nl' => 'Inhoud',
                ],
                'description' => [
                    'fr' => 'Sélectionnez les différents types de paragraphes que vous voulez faire remonter sur la page',
                    'en' => 'Select the different types of paragraphs you want to move up the page',
                    'es' => 'Seleccione los diferentes tipos de párrafos que desea mover hacia arriba en la página',
                    'de' => 'Wählen Sie die verschiedenen Arten von Absätzen aus, die Sie auf der Seite nach oben verschieben möchten',
                    'pt' => 'Selecione os diferentes tipos de parágrafos que deseja mover para cima da página',
                    'nl' => 'Selecteer de verschillende soorten alinea\'s die u naar boven wilt verplaatsen op de pagina',
                ],
                'widget' => [
                    'type' => BridgeContentType::SECTION_WIDGET,
                    'settings' => [
                        'title' => 'Paragraphe',
                        'title_plural' => 'Paragraphes',
                        'edit_mode' => 'open',
                        'add_mode' => 'dropdown',
                        'form_display_mode' => 'default',
                        'default_paragraph_type' => '',
                    ],
                    'weight' => 2,
                ],
                'type' => BridgeContentType::SECTION_FIELD,
                'settings' => [
                    'target_type' => [
                        'text',
                        'text_two_columns',
                        'text_with_image',
                        'separator',
                        'file',
                        'slider',
                        'image',
                        'video',
                        'map',
                        'accordion',
                        'call_to_action',
                        'button',
                        'html',
                        'tweet',
                        'fetched_contents',
                    ],
                    'cardinality' => -1,
                ],
            ],
        );

        $bridge->contentTypeCreateOrUpdateField(
            type: 'spaces',
            fieldName: 'establishments',
            options: [
                'name' => 'establishments',
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => true,
                'searchable_filter' => true,
                'required' => false,
                'weight' => 10,
                'title' => [
                    'fr' => 'ESMS',
                ],
                'description' => [],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 1,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['establishments'],
                    'cardinality' => 1,
                ],
            ],
        );

        $bridge->contentTypeCreateOrUpdateField(
            type: 'spaces',
            fieldName: 'link',
            options: [
                'name' => 'link',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 1,
                'title' => [
                    'fr' => 'Lien',
                ],
                'widget' => [
                    'type' => BridgeContentType::INSIDE_LINK_WIDGET,
                    'settings' => [],
                    'weight' => 1,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ]
        );
    }
}
