<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'tabs_spaces',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => true,
        'listing_type' => 'taxo',
        'title' => [
            'fr' => 'Espace à onglets',
            'en' => 'Tab spaces',
            'nl' => 'Tabbladen',
            'pt' => 'Espaços de tabulação',
            'es' => 'Espacios de tabulación',
            'de' => 'Tabulator-Leerzeichen',
        ],
    ],
    'fields' => [
        [
            'name' => 'banner',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Bannière',
                'en' => 'Banner',
                'nl' => 'Banier',
                'pt' => 'Bandeira',
                'es' => 'Bandera',
                'de' => 'Banner',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'introduction',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Introduction',
                'en' => 'Introduction',
                'nl' => 'Invoering',
                'pt' => 'Introdução',
                'es' => 'Introducción',
                'de' => 'Einführung',
            ],
            'description' => [
                'fr' => 'L\'introduction de l\'espace remonte sous le titre dans la bannière',
                'en' => 'The introduction of the space goes up under the title in the banner',
                'nl' => 'De introductie van de ruimte staat onder de titel in de banner',
                'pt' => 'A introdução do espaço aparece abaixo do título do banner',
                'es' => 'La introducción del espacio aparece debajo del título en el banner.',
                'de' => 'Die Einführung des Raums erscheint unter dem Titel im Banner',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
    ],
];
