import { http } from '@inside-library/helpers/Http'

export const fetchSpacesListingPage = async ({ $route }) => {
  try {
    const { data: tabsSpaces } = await http.get('content/tabs_spaces', {
      fields: [
        'uuid',
        'admin',
        'title',
        'content_type',
        'slug',
        'image',
        'weight'
      ],
      filters: {
        sort: 'weight:asc',
        limit: 16,
        space_landings: { 'slug:eq': $route.params.slug }
      }
    })

    const { data: spaceLandings } = await http.get('content/space_landings', {
      fields: [
        'uuid',
        'admin',
        'title',
        'content_type',
        'banner',
        'introduction'
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return [tabsSpaces, spaceLandings[0]]
  } catch (err) {
    throw new Error(err)
  }
}