import SpacesListingPage from '../pages/spaces/SpacesListingPage'
import { fetchSpacesListingPage } from '../components/spaces/spaces'

import ClubListingPage from '../pages/clubs/ClubListingPage'
import ClubPage from '../pages/clubs/ClubPage'
import { fetchClubListingPage, fetchClubPage } from '../components/clubs/clubs'

import { fetchProject } from '../components/projects/projects'
import ProjectPage from '../pages/project/ProjectPage'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'EventSubscriptionPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false,
      extraFilters: {
        sort: 'weight:asc'
      }
    }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'SpacesListingPage',
    path: {
      fr: '/listing-espaces/:slug',
      en: '/spaces-listing/:slug'
    },
    meta: { content: 'space_landings' },
    component: withFetch(SpacesListingPage, {
      size: 'xxl',
      watch: true
    })(fetchSpacesListingPage)
  },
  {
    name: 'TabsSpacePage',
    meta: { disabled: false }
  },
  {
    name: 'ClubListingPage',
    path: '/clubs',
    component: withFetch(ClubListingPage, { size: 'xxl' })(fetchClubListingPage)
  },
  {
    name: 'ClubPage',
    path: '/clubs/:slug',
    meta: { content: 'spaces' },
    component: withFetch(ClubPage, { size: 'xxl' })(fetchClubPage)
  },
  {
    name: 'ProjectPage',
    path: {
      fr: '/projet/:slug',
      en: '/project/:slug'
    },
    meta: { content: 'projects' },
    component: withFetch(ProjectPage, { size: 'xxl' })(fetchProject)
  },
  {
    name: 'FAQListingPage',
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  }
]
