import { http } from '@inside-library/helpers/Http'

export default {
  spaces: {
    add: ({ data }) => {
      return {
        name: 'ClubPage',
        params: { slug: data.slug[0] }
      }
    }
  },
  projects: {
    add: ({ data }) => {
      return {
        name: 'ProjectPage',
        params: { slug: data.slug[0] }
      }
    },
    globalSearch: async ({ data }) => {
      return {
        route: {
          name: 'ProjectPage',
          params: {
            slug: data.slug[0]
          }
        }
      }
    }
  },
  projectFolders: {
    add: async ({ data }) => {
      try {
        const { data: projectFolder } = await http.get(
          'content/project_folders',
          {
            fields: [
              {
                projects: ['slug']
              }
            ],
            filters: { 'uuid:eq': data.uuid }
          }
        )

        if (projectFolder[0].projects.data.length) {
          return {
            name: 'ProjectPage',
            params: {
              slug: projectFolder[0].projects.data?.[0]?.slug?.[0]
            },
            query: {
              folder: data.uuid
            }
          }
        } else {
          return {
            name: 'HomePage'
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    delete: () => ({
      name: 'HomePage'
    })
  },
  projectDocuments: {
    add: async ({ fields }) => {
      try {
        const { data: projectData } = await http.get('content/projects', {
          fields: ['slug'],
          filters: {
            project_folders: {
              'uuid:eq': fields.project_folders[0]
            }
          }
        })

        return {
          name: 'ProjectPage',
          params: {
            slug: projectData[0]?.slug?.[0]
          },
          query: { folder: fields?.project_folders?.[0] }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    delete: async data => {
      try {
        const { data: projectFolder } = await http.get(
          'content/project_documents',
          {
            fields: [
              {
                project_folders: ['uuid']
              }
            ],
            filters: {
              'uuid:eq': data.uuid
            }
          }
        )

        const { data: projectData } = await http.get('content/projects', {
          fields: ['slug'],
          filters: {
            project_folders: {
              'uuid:eq': projectFolder[0].project_folders.data?.[0]?.uuid
            }
          }
        })

        return {
          name: 'ProjectPage',
          params: {
            slug: projectData[0]?.slug?.[0]
          },
          query: { folder: projectFolder[0].project_folders.data?.[0]?.uuid }
        }
      } catch (err) {
        throw new Error(err)
      }
    }
  },
  services: {
    add: () => ({
      name: 'HomePage'
    })
  },
  spaceLandings: {
    add: ({ data }) => {
      return {
        name: 'SpacesListingPage',
        params: { slug: data.slug[0] }
      }
    }
  }
}
