export default {
  globals: {
    calendarExportTypes: [
      {
        type: 'outlook',
        label: 'Outlook'
      }
    ]
  },
  'inside-events': {
    subscriptionEnabled: true
  },
  'inside-edition': {
    duplicateEnabled: true
  },
  'inside-layouts': {
    gdprContent: 'popins'
  },
  'inside-news': {
    minimalDate: true
  },
  'inside-users': {
    allowAvatarDeletion: false,
    allowAvatarEdition: false,
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    },
    paragraphs: {
      fetchedContents: {
        display: () => import('./components/users/UserCard'),
        requestFields: [
          'uuid',
          'image',
          'firstname',
          'lastname',
          'email',
          'function',
          'trigram'
        ]
      }
    }
  },
  'inside-workflows': {
    isEnabled: true
  }
}
