import { http } from '@inside-library/helpers/Http'

export const fetchProject = async ({ $route }) => {
  try {
    const { data } = await http.get('content/projects', {
      fields: [
        'uuid',
        'title',
        'content_type',
        'banner',
        'description',
        'admin',
        'short_summary',
        'statuses',
        'locations',
        {
          users: {
            fields: [
              'uuid',
              'firstname',
              'lastname',
              'image',
              'function',
              'email',
              'trigram'
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          news: {
            fields: [
              'uuid',
              'title',
              'content_type',
              'slug',
              'published_at',
              'image'
            ],
            filters: {
              'status:eq': 1,
              sort: 'published_at:desc'
            }
          }
        },
        {
          tools: {
            fields: [
              'title',
              'uuid',
              'has_section',
              'tools_link',
              'admin',
              'image',
              'class',
              'content_type',
              {
                tools_categories: [
                  'uuid',
                  { tools_categories_listings: ['uuid', 'slug'] }
                ]
              }
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          project_folders: {
            fields: ['uuid', 'title'],
            filters: {
              reverse: true,
              'status:eq': 1,
              sort: 'published_at:desc'
            }
          }
        }
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
