import { http } from '@inside-library/helpers/Http'

const fetchCardLink = async () => {
  try {
    const { data: blocksCategories } = await http.get(
      'content/block_categories',
      {
        fields: ['uuid', 'title', 'admin', 'published_at', 'content_type'],
        // filtre à passer en weight:asc quand le poids est rajouté pour les catégories de blocs
        filters: { 'status:eq': 1, sort: 'published_at:asc' }
      }
    )

    const { data: cardsLinks } = await http.get('content/cards_links', {
      fields: [
        'uuid',
        'title',
        'admin',
        'image',
        'link',
        'published_at',
        'content_type',
        'block_categories'
      ],
      filters: { 'status:eq': 1, sort: 'weight:asc' }
    })

    return [blocksCategories, cardsLinks]
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchCardLink }
