<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class MakeProjectPermissibleAndCategorizable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeUpdateOrCreate(
            type: 'projects',
            options: [
                'name' => 'projects',
                'permissible' => true,
                'categorizable' => true,
                'listing_type' => 'content',
            ]
        );

        Artisan::call("models:rebuild");
    }
}
