<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;

class AddIntroduceFieldInSpaceLandings extends Migration
{
    public function up(): void
    {
        if (InsideSchema::hasField('space_landings', 'introduction')) {
            return;
        }

        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'space_landings',
            fieldName: 'introduction',
            options: [
                'name' => 'introduction',
                'searchable' => true,
                'translatable' => true,
                'search_result_field' => true,
                'searchable_filter' => false,
                'required' => true,
                'weight' => 2,
                'title' => [
                    'fr' => 'Introduction',
                    'en' => 'Introduction',
                    'es' => 'Introducción',
                    'nl' => 'Inleiding',
                    'de' => 'Einführung',
                    'pt' => 'Introdução',
                ],
                'description' => [
                    'fr' => 'L\'introduction remonte sur les pages de listing d\'actualité et n\'est pas dupliquée dans votre contenu',
                    'en' => 'The introduction goes up on the news listing pages and is not duplicated in your content',
                    'es' => 'La introducción sube en las páginas de listado de noticias y no se duplica en su contenido',
                    'nl' => 'De inleiding komt op de nieuwslijstpagina\'s en wordt niet gedupliceerd in uw inhoud',
                    'de' => 'Die Einführung wird auf den Nachrichtenlisten-Seiten nach oben verschoben und nicht in Ihrem Inhalt dupliziert',
                    'pt' => 'A introdução sobe nas páginas de listagem de notícias e não é duplicada em seu conteúdo',
                ],
                'widget' => [
                    'type' => BridgeContentType::LONGTEXT_WIDGET,
                    'settings' => [
                        'rows' => 5,
                        'placeholder' => '',
                    ],
                    'weight' => 2,
                ],
                'type' => BridgeContentType::TEXTAREA_FIELD,
                'settings' => [
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            weight: 2
        );

        $bridge->contentTypeCreateOrUpdateField(
            type: 'space_landings',
            fieldName: 'banner',
            options: [
                'name' => 'banner',
                'translatable' => true,
                'weight' => 1,
                'title' => [
                    'fr' => 'Bannière',
                    'en' => 'Banner',
                    'nl' => 'Bannieère',
                    'de' => 'Banner',
                    'es' => 'Banner',
                    'pt' => 'Banner',
                ],
                'widget' => [
                    'type' => BridgeContentType::IMAGE_WIDGET,
                    'settings' => [
                        'progress_indicator' => 'throbber',
                        'preview_image_style' => 'thumbnail',
                    ],
                    'weight' => 1,
                ],
            ],
            weight: 1
        );
    }
}
