<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Illuminate\Support\Facades\Artisan;

final class RemoveProjectDocumentsFields extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField(entityType: 'node', type: 'projects', fieldName: 'project_documents');

        Artisan::call("models:rebuild");
    }
}
