<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

final class AddIsHiddenFieldInUsers extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridgeContent = new BridgeContent();

        $bridge->contentTypeCreateOrUpdateField('users', 'is_hidden_in_directory', [
            'name' => 'is_hidden_in_directory',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'search_filter' => true,
            'required' => false,
            'weight' => 12,
            'title' => [
                'fr' => 'Ne pas afficher dans l’annuaire',
                'en' => 'Hide user in directory'
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 12,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ], 12);

        Artisan::call('models:rebuild');

        Users::each(fn ($user) => $bridgeContent->contentUpdate('users', [
            'uuid' => $user->uuid,
            'is_hidden_in_directory' => $user->is_maintenance
        ]));
    }
}
