<?php

use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Inside\Authentication\Models\User;

$validLocations = collect(['qd_paris', 'qd_montreal']);
return [
    'postfilter' => function (Collection $users): Collection {
        $images = User::where('provider_type', 'azuread')->with('information')->get()->pluck('information.image', 'email');

        return $users
            ->filter(
                fn (mixed $user) =>
                str(strtolower($user->userPrincipalName))->endsWith('@quanticdream.com') &&
                str($user->userPrincipalName)->length() <= 60 &&
                ! str_contains($user->userPrincipalName, '_') &&
                ! blank($user->surname) &&
                ! blank($user->jobTitle) &&
                $user->accountEnabled
            )->map(function ($user) use ($images) {
                $user->image = $images->get($user->mail) ?: null;

                return $user;
            });
    },
    'sync_attributes' => [
        'email' => 'mail',
        'name' => 'userPrincipalName',
        'firstname' => 'givenName',
        'lastname' => 'surname',
        'function' => 'jobTitle',
        'trigram' => 'onPremisesSamAccountName',
        'services' => fn (mixed $user) => reference('services')
            ->identifiedBy('code')
            ->from(ucfirst($user->department))
            ->get(),
        'companies' => fn (mixed $user) => reference('companies')
            ->identifiedBy('code')
            ->from(ucfirst($user->companyName))
            ->get(),
        'locations' => fn (mixed $user) => reference('locations')
            ->identifiedBy('code')
            ->from(
                $validLocations->contains(str($user->companyName ?? '')->lower()) ?
                    str($user->companyName)->after('_') : null
            )
            ->get(),
        'cities' => fn (mixed $user) => reference('cities')
            ->identifiedBy('code')
            ->from($user->city)
            ->get(),
        'offices' => fn (mixed $user) => reference('offices')
            ->identifiedBy('code')
            ->from(ucfirst($user->officeLocation))
            ->get(),
        'managers' => fn (mixed $user) => reference('users')
            ->identifiedBy('email')
            ->from($user->manager)
            ->withoutCreation()
            ->get(),
        'is_manager' => fn ($user) => isset($user->employeeId) && !empty($user->employeeId),
        'status' => fn () => 1,
    ],
    'custom_attributes' => [
        'manager' => 'mail',
    ]
];
