<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class MakeFlashNewsTranslatable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeUpdate('flash_news', [
            'name' => 'flash_news',
            'translatable' => true,
        ]);

        $bridge->changeFieldFormOptions('flash_news', 'langcode', true, 'group_advanced_options');

        Artisan::call("models:rebuild");
    }
}
