<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class AlterLandingSpacesPermissions extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeUpdateOrCreate('space_landings', [
            'name' => 'space_landings',
            'permissible' => true,
            'categorizable' => true,
            'listing_type' => 'content',
        ]);

        $bridge->contentTypeUpdateOrCreate('tabs_spaces', [
            'name' => 'tabs_spaces',
            'permissible' => true,
            'categorizable' => true,
            'listing_type' => 'content',
        ]);

        $bridge->contentTypeUpdateOrCreate('tabs', [
            'name' => 'tabs',
            'permissible' => true,
            'categorizable' => false,
            'listing_type' => 'content',
        ]);

        $bridge->contentTypeUpdateOrCreate('tabs_pages', [
            'name' => 'tabs_pages',
            'permissible' => true,
            'categorizable' => false,
            'listing_type' => 'content',
        ]);

        Artisan::call("models:rebuild");
    }
}
