<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Tools;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Models\Contents\Users;

class UpdateQuanShortcut extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();
        $bridgeContentType = new BridgeContentType();

        $toolsUuidFR = [
            '5700809f-3c52-4f80-8a7e-82ccf81ec38d' => 0,
            '03fbc129-7a27-411b-9198-578e722767fc' => 1,
            '7e19d823-a8a4-462f-ae27-f3bc2007e7a4' => 2,
            '7ac3d222-341c-46c3-a6a1-02521556fadd' => 3,
            '2c64b199-2cfa-4198-9d84-1751eac22b1b' => 4,
        ];

        $toolsUuidCA = [
            '7b64a2e7-e7ad-48c1-986f-7bb9f292d954' => 0,
            '83836dcf-e017-42e2-bada-5db32d38fd4e' => 1,
            'eeba64c2-4124-4b20-988a-564466238483' => 2,
            'b473ff2b-dcff-4573-ae00-ff1a7c1c5db6' => 3,
            '2c64b199-2cfa-4198-9d84-1751eac22b1b' => 4,
        ];

        $toolsFR = Tools::query()
            ->whereIn('uuid', array_keys($toolsUuidFR))
            ->get()
            ->sortBy(fn ($tool) => $toolsUuidFR[$tool->uuid]);

        $toolsFR->each(function ($tool) use ($bridge, $toolsUuidFR) {
            $bridge->contentUpdate(
                type: 'tools',
                data: [
                    'uuid' => $tool->uuid,
                    'title' => $tool->title,
                    'weight' => $toolsUuidFR[$tool->uuid],
                ]
            );
        });

        $toolsCA = Tools::query()
            ->whereIn('uuid', array_keys($toolsUuidCA))
            ->get()
            ->sortBy(fn ($tool) => $toolsUuidCA[$tool->uuid]);

        $toolsCA->each(function ($tool) use ($bridge, $toolsUuidCA) {
            $bridge->contentUpdate(
                type: 'tools',
                data: [
                    'uuid' => $tool->uuid,
                    'title' => $tool->title,
                    'weight' => $toolsUuidCA[$tool->uuid],
                ]
            );
        });

        $defaultToolsFR = $toolsFR->map(function ($tool) {
            return ['target_uuid' => $tool->uuid_host];
        })->toArray();

        $defaultToolsCA = $toolsCA->map(function ($tool) {
            return ['target_uuid' => $tool->uuid_host];
        })->toArray();

        $bridgeContentType->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'tools',
            options: [
                'title' => [
                    'fr' => 'Accès rapide',
                    'en' => 'Quick access'
                ],
                'default' => $defaultToolsFR
            ]
        );

        Users::whereHas('cities', fn ($query) => $query->where('title', 'Paris'))->each(
            fn ($user) => $bridge->updateReferenceFields(
                type: 'users',
                contentUuidHost: $user->uuid_host,
                data: [
                    'tools' => $defaultToolsFR
                ]
            )
        );

        Users::whereHas('cities', fn ($query) => $query->where('title', 'Montreal'))->each(
            fn ($user) => $bridge->updateReferenceFields(
                type: 'users',
                contentUuidHost: $user->uuid_host,
                data: [
                    'tools' => $defaultToolsCA
                ]
            )
        );
    }
}
