<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

final class AddPronounFieldInUsers extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridgeContent = new BridgeContent();

        $bridge->contentTypeCreateOrUpdateField('users', 'pronoun', [
          'name' => 'pronoun',
          'searchable' => true,
          'translatable' => true,
          'editable' => true,
          'search_result_field' => false,
          'searchable_filter' => false,
          'required' => false,
          'weight' => 13,
          'title' => [
            'fr' => 'Pronom',
            'en' => 'Pronoun',
          ],
          'widget' => [
            'type' => BridgeContentType::STRING_WIDGET,
            'settings' => [
              'size' => 60,
              'placeholder' => '',
            ],
            'weight' => 13,
          ],
          'type' => BridgeContentType::TEXT_FIELD,
          'settings' => [
            'max_length' => 255,
            'is_ascii' => false,
            'case_sensitive' => false,
            'cardinality' => 1,
          ],
        ], 13);

        Artisan::call('models:rebuild');
    }
}
