<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class CreateOfficesTypeAndField extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->migrateContent('offices');

        Artisan::call('models:rebuild');

        $this->getBridge()?->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'offices',
            options: [
                'name' => 'offices',
                'searchable' => true,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 8,
                'title' => [
                    'en' => 'Office',
                    'fr' => 'Bureau',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 8,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => 'offices',
                    'cardinality' => 1,
                ],
            ],
            weight: 8
        );
        $this->finishUp();
    }
}
