<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Bridge\BridgeContent;
use Illuminate\Support\Facades\Artisan;

final class RemoveUselessProjectFields extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        collect(['statuses','locations'])->each(
            fn ($fieldName) => $bridge->contentTypeDeleteField(entityType: 'node', type: 'projects', fieldName: $fieldName)
        );
        Artisan::call("models:rebuild");
    }
}
