<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Bridge\BridgeContent;

final class AddFieldCodeToAzureadContentTypes extends Migration
{
    public function up(): void
    {
        $bridgeContent = new BridgeContent();
        $bridge = new BridgeContentType();

        collect(['companies', 'services'])->each(function ($contentType) use ($bridge, $bridgeContent) {
            $bridge->contentTypeCreateOrUpdateField($contentType, 'code', [
                'name' => 'code',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 0,
                'title' => [
                    'fr' => 'code',
                    'en' => 'code',
                ],
                'widget' => [
                    'hidden' => true,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ]);

            /** @var \Illuminate\Support\Collection $contents */
            $contents = type_to_class($contentType)::all();

            $contents->each(fn ($content) => $bridgeContent->contentUpdate($contentType, [
                'uuid' => $content->uuid,
                'code' => $content->title,
            ]));
        });
    }
}
