<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class ModifyProjectDocumentsRefToProjectFolders extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('node', 'project_documents', 'project_documents');

        $bridge->contentTypeCreateOrUpdateField('project_documents', 'project_folders', [
            'name' => 'project_folders',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Dossier Parent',
                'en' => 'Parent folder',
            ],
            'description' => [
                'fr' => 'Dossier dans lequel le document remontera',
                'en' => 'Folder in which the document will be stored',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['project_folders'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ]);
    }
}
