<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'users',
        'translatable' => false,
        'searchable' => false,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => false,
        'listing_type' => 'hidden',
        'title' => [
            'fr' => 'Utilisateur',
            'en' => 'Users',
        ],
    ],
    'fields' => [
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Photo de profil',
                'en' => 'Profile picture',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'firstname',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Prénom',
                'en' => 'First name',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'lastname',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Nom',
                'en' => 'Last name',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'function',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Fonction',
                'en' => 'Fonction',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'services',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Services',
                'en' => 'Services',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 4,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['services'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'trigram',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Trigramme',
                'en' => 'Trigram',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'project_codes',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 5,
            'title' => [
                'fr' => 'Code projet',
                'en' => 'Project code',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 5,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['project_codes'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'locations',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 6,
            'title' => [
                'fr' => 'Localisation',
                'en' => 'Location',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 6,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['locations'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'companies',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 7,
            'title' => [
                'fr' => 'Société',
                'en' => 'Company',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 7,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['companies'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'is_manager',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 8,
            'title' => [
                'fr' => 'Je suis manager',
                'en' => 'I am a manager',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 8,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
        [
            'name' => 'managers',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 9,
            'title' => [
                'fr' => 'Manager',
                'en' => 'Manager',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 9,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'users',
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'tools',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 10,
            'title' => [
                'fr' => 'Accès rapides',
                'en' => 'Tools',
            ],
            'widget' => [
                'type' => BridgeContentType::OPTIONS_BUTTONS_WIDGET,
                'settings' => [],
                'weight' => 10,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['tools'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'is_maintenance',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => true,
            'required' => false,
            'weight' => 11,
            'title' => [
                'fr' => 'Compte de maintenance ?',
                'en' => 'Maintenance Account ?',
            ],
            'description' => [
                'fr' => 'Si cette case est cochée l\'utilisateur ne remontera pas dans l\'annuaire de l\'intranet',
                'en' => 'If this box is checked, the user will not be listed in the intranet directory.',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 11,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
        [
            'name' => 'send_mail',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 12,
            'title' => [
                'fr' => 'Envoyer un mail à la création de mot de passe',
                'en' => 'Send an email to create a password',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 12,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
        [
            'name' => 'is_gdpr_compliant',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 13,
            'title' => [
                'fr' => 'RGPD Compliant',
                'en' => 'RGPD Compliant',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 13,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
    ],
];
