<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => false,
        'name' => 'project_links',
        'title' => [
            'fr' => 'Lien',
            'en' => 'Link',
        ],
        'deletion_strategy' => 'only_parent',
    ],
    'fields' => [
        // Uri
        [
            'type' => BridgeContentType::TEXT_FIELD,
            'name' => 'uri',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'default' => '',
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Lien',
                'en' => 'Link',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_LINK_WIDGET,
            ],
        ],

        // Open in a new tab
        [
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'name' => 'open_in_new_tab',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'default' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Ouverture dans un nouvel onglet',
                'en' => 'Open in a new tab',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
            ],
        ],

        // Folders
        [
            'name' => 'project_documents',
            'searchable' => false,
            'translatable' => false,
            'default' => [],
            'search_result_field' => false,
            'required' => true,
            'weight' => 3,
            'reference_is_a_parent' => true,
            'title' => [
                'fr' => 'Dossier projet parent',
                'en' => 'Parent project folder',
            ],
            'description' => [
                'fr' => 'Dossier parent',
                'en' => 'Parent folder',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 4,
                'group' => 'group_advanced_options',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['project_documents'],
                'cardinality' => -1,
            ],
        ],

        // Image
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Image de prévisualisation',
                'en' => 'Preview image',
            ],
            'description' => [
                'fr' => 'Cette image sera utilisée comme image de prévisualisation dans un dossier de médiathèque',
                'en' => 'This image will be used as preview in a media folder',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
    ],
];
