import SpacePage from '../pages/spaces/SpacePage'
import TabSpacePage from '../pages/spaces/TabSpacePage'
import { fetchSpace } from '../components/spaces/fetch'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'EventSubscriptionPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: { homeWithCards: false }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false, content: 'pages' }
  },
  {
    name: 'FAQListingPage',
    meta: { disabled: false }
  },
  {
    name: 'DirectoryPage',
    meta: { disabled: false },
    component: () => import('../pages/users/DirectoryPage')
  },
  {
    name: 'SpacesListingPage',
    component: () => import('../pages/spaces/SpacesListingPage'),
    path: '/espaces'
  },
  {
    name: 'SpacePage',
    component: withFetch(SpacePage, { size: 'xxl', watch: true })(fetchSpace),
    path: '/espaces/:slug'
  },
  {
    name: 'TabSpacePage',
    component: withFetch(TabSpacePage, { size: 'xxl', watch: true })(
      fetchSpace
    ),
    path: '/espaces/:slug/page'
  },
  {
    name: 'MapPage',
    meta: { disabled: false },
    component: () => import('../pages/map/MapPage')
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  }
]
